capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Stata Index"
set more off
log using Output/log/anTNSP25-pooled, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics 2025 TNSP Benchmarking
Author:  Michael Cunningham
File:    anTNSP25-pooled.do
Initial Date:    7-Jul-2022
Revised Date:	 8-Jul-2025
--------------------------------------------------------------------------*/

scalar define rss1     = 0.09445
scalar define rss2     = 0.28685
scalar define rss3     = 0.0933
scalar define rss4     = 0.5254

local outputs energy ratchetmd customers circlength ens
local inputs ropex overline undercable transform
local costs opex auc_overline auc_undercable auc_transform
	

* Read dataset & create variables

use Input/dta/tnspbench25-firm, clear

drop if tnsp == 26
describe, fullnames
summarize

* output and input quantities

local j = 1
foreach i of local outputs {
	gen q`j' = `i'
	local ++j
}

local j = 1
foreach i of local inputs {
	gen x`j' = `i'
	local ++j
}

* Input costs and cost shares

local j = 1
foreach i of local costs {
	gen c`j' = `i'
	local ++j
}
gen tc = c1 + c2 + c3 + c4

forvalues i = 1/4 {
	gen cs`i' = c`i' / tc
	gen w`i' = c`i' / x`i'
	gen lx`i' = log(x`i')
}

* Capital inputs only

gen kc = c2 + c3 + c4
forvalues i = 2/4 {
	gen ks`i' = c`i' / kc
}

* Output values and value shares

gen v5 = - adjvens
gen grossrev = revenue + adjvens

*** CHECK UNITS IN ABOVE 2 LINES ***

forvalues i = 1/4 {
	gen v`i' = rss`i'*grossrev
}

forvalues i = 1/5 {
	gen vs`i' = v`i'/ revenue
	gen p`i' = v`i'/ q`i'
	gen lq`i' = log(q`i')
}

gen rshrtest = vs1 + vs2 + vs3 + vs4 + vs5
summarize rshrtest
drop rshrtest

* Means & Lags

forvalues j = 1/4 {
	summarize lx`j', meanonly 
	scalar define lx`j'_m = r(mean)
	summarize cs`j', meanonly 
	scalar define cs`j'_m = r(mean)	
	gen lx`j'_l = lx`j'[_n-1]
	gen cs`j'_l = cs`j'[_n-1]	
}

forvalues j = 1/5 {
	summarize lq`j', meanonly 
	scalar define lq`j'_m = r(mean)
	summarize vs`j', meanonly 
	scalar define vs`j'_m = r(mean)	
	gen lq`j'_l = lq`j'[_n-1]
	gen vs`j'_l = vs`j'[_n-1]	
}

forvalues j = 2/4 {
	summarize ks`j', meanonly 
	scalar define ks`j'_m = r(mean)	
	gen ks`j'_l = ks`j'[_n-1]	
}

scalar list
describe

* Output Index

foreach k of numlist 1/5 {
	gen outdelta`k' = (vs`k' + vs`k'_m)*(lq`k' - lq`k'_m)/2 ///
			      - (vs`k'_l + vs`k'_m)*(lq`k'_l - lq`k'_m)/2
}
gen outdelta = outdelta1 + outdelta2 + outdelta3 + outdelta4 + outdelta5
gen outx = 1
replace outx = outx[_n-1] * exp(outdelta) if _n > 1 

* Input Index

foreach k of numlist 1/4 {
	gen indelta`k' = (cs`k' + cs`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (cs`k'_l + cs`k'_m)*(lx`k'_l - lx`k'_m)/2
}
gen indelta = indelta1 + indelta2 + indelta3 + indelta4
gen inx = 1
replace inx = inx[_n-1] * exp(indelta) if _n > 1 


* TFP Index

gen tfpdelta = outdelta - indelta
gen tfpx = 1
replace tfpx = tfpx[_n-1] * exp(tfpdelta) if _n > 1 

* Opex PFP Index

gen odelta = lx1 - lx1_l
gen opinx = 1
replace opinx = opinx[_n-1] * exp(odelta) if _n > 1 
gen opfpdelta = outdelta - odelta
gen opfpx = 1
replace opfpx = opfpx[_n-1] * exp(opfpdelta) if _n > 1 

* Capital Index

foreach k of numlist 2/4 {
	gen kdelta`k' = (ks`k' + ks`k'_m)*(lx`k' - lx`k'_m)/2 ///
			      - (ks`k'_l + ks`k'_m)*(lx`k'_l - lx`k'_m)/2
}
gen kdelta = kdelta2 + kdelta3 + kdelta4
gen kinx = 1
replace kinx = kinx[_n-1] * exp(kdelta) if _n > 1 

* Capital PFP Index

gen kpfpdelta = outdelta - kdelta
gen kpfpx = 1
replace kpfpx = kpfpx[_n-1] * exp(kpfpdelta) if _n > 1 


* Individual output and input indexes

forvalues j = 1/5 {
	gen q`j'x = 1
	replace q`j'x = q`j'x[_n-1] * (q`j' / q`j'[_n-1]) if year > 2006
}

forvalues i = 1/4 {
	gen x`i'x = 1
	replace x`i'x = x`i'x[_n-1] * (x`i' / x`i'[_n-1]) if year > 2006
}


* Write results file

export excel tnsp year outx inx tfpx opinx kinx opfpx kpfpx tfpdelta ///
	outdelta indelta outdelta1 outdelta2 outdelta3 outdelta4 outdelta5 ///
	indelta1 indelta2 indelta3 indelta4 odelta kdelta  ///
	q1x q2x q3x q4x q5x x1x x2x x3x x4x using Output/excel/tnsp25_pooled.xlsx, ///
	firstrow(var) replace

*save Output/dta/tnsp25_pooled, replace

log close
exit
